package com.atlassian.bitbucket.event.attachment;

import com.atlassian.bitbucket.attachment.Attachment;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Base type for all attachment related events.
 *
 * @since 7.0
 */
@TransactionAware
public class AttachmentEvent extends ApplicationEvent {

    private final Attachment attachment;
    private final Repository repository;

    /**
     * Construct a new {@code AttachmentEvent}.
     *
     * @param source        the component raising the event
     * @param repository    the repository
     * @param attachment    the attachment
     */
    protected AttachmentEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Attachment attachment) {
        super(source);

        this.attachment = requireNonNull(attachment, "attachment");
        this.repository = requireNonNull(repository, "repository");
    }

    @Nonnull
    public Attachment getAttachment() {
        return attachment;
    }

    @Nonnull
    public Repository getRepository() {
        return repository;
    }
}
