package com.atlassian.bitbucket.dashboard;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import java.util.Date;

/**
 * An object encapsulating data necessary to suggest creation of a pull request to the user.
 * Such suggestions are based on ref changes occurring and so contain the ref change that prompted
 * the suggestion plus the time the change event occurred.
 *
 * @since 4.10
 */
public interface PullRequestSuggestion {

    /**
     * @return The date/time that the ref change occurred
     */
    @Nonnull
    Date getChangeDate();

    /**
     * @return the branch that should be the <strong>source</strong> branch for the pull request
     */
    @Nonnull
    MinimalRef getFromRef();

    /**
     * @return the branch that should be the <strong>destination</strong> branch for the pull request
     */
    @Nonnull
    MinimalRef getToRef();

    /**
     * @return the ref change that was the basis for suggesting a pull request
     */
    @Nonnull
    RefChange getRefChange();

    /**
     * @return the repository the suggested pull request is for
     */
    @Nonnull
    Repository getRepository();
}
