package com.atlassian.bitbucket.content;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Represents a node in a source tree.
 */
public interface ContentTreeNode {

    /**
     * @return an ID that identifies the contents of the node.
     */
    @Nullable
    String getContentId();

    /**
     * @return the path for the node
     */
    @Nonnull
    Path getPath();

    /**
     * @return the type of the ContentTreeNode
     */
    @Nonnull
    Type getType();

    /**
     * Enumeration of ContentTreeNode types
     */
    enum Type {
        DIRECTORY,
        FILE,
        /**
         * Represents a remote link to an external repository.
         */
        SUBMODULE
    }
}