package com.atlassian.bitbucket.avatar;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public class NoSuchAvatarException extends NoSuchEntityException {

    private final String id;

    public NoSuchAvatarException(@Nonnull KeyedMessage message, @Nonnull String id) {
        super(message);

        this.id = requireNonNull(id, "id");
    }

    @Nonnull
    public String getId() {
        return id;
    }
}
