package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * A specialisation of {@link AuthenticationException}, thrown to indicate the password supplied during an
 * authentication attempt does not match the password on record. It is also thrown when a user attempts to
 * change their password but the current password they provide does not match the password on record.
 */
public class IncorrectPasswordAuthenticationException extends AuthenticationException {

    public IncorrectPasswordAuthenticationException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
