package com.atlassian.bitbucket.validation.annotation;

import com.atlassian.bitbucket.validation.RequiredUriValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.constraints.NotNull;
import java.lang.annotation.*;
import java.net.URI;

/**
 * Validates that a URI is present and that it's {@link URI#toASCIIString() ASCII representation} does not exceed
 * {@link #size()} characters in length
 *
 * @see java.net.URI
 * @since 4.7
 */
@Documented
@NotNull
@Constraint(validatedBy = RequiredUriValidator.class)
@Target({ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface RequiredUri {
    Class<?>[] groups() default {};

    String message() default "{com.atlassian.bitbucket.validation.httpuri.message}";

    Class<? extends Payload>[] payload() default {};

    int size() default Integer.MAX_VALUE;
}
