package com.atlassian.bitbucket.user;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;

/**
 * Raised when the execution of delegated erasure operations fails.
 * <p>
 * User erasure is pluggable, and erasing a user may trigger multiple individual handlers--each of which may
 * fail. To communicate multiple failures, {@link #getCauses()} maps between the module ID for, and exception
 * from, each failed handler.
 *
 * @see UserAdminService#eraseUser(String)
 * @since 5.16
 */
public class UserErasureException extends ServiceException {

    private final Map<String, Throwable> causes;

    public UserErasureException(@Nonnull KeyedMessage message) {
        super(message);

        causes = Collections.emptyMap();
    }

    public UserErasureException(@Nonnull KeyedMessage keyedMessage, @Nonnull Map<String, Throwable> causes) {
        super(keyedMessage);
        this.causes = causes;

        causes.values().forEach(this::addSuppressed);
    }

    @Nonnull
    public Map<String, Throwable> getCauses() {
        return causes;
    }
}
