package com.atlassian.bitbucket.topic;

import javax.annotation.Nonnull;
import java.io.Serializable;

/**
 * Callback interface for messages sent to a {@link Topic#subscribe(TopicListener) topic}.
 * <p>
 * Note: {@link #onMessage(MessageEvent)} is called from one of a limited number of message delivery
 * threads. If a callback needs to do significant processing, it should hand off the work to an {@code Executor} to
 * ensure the message delivery threads don't get tied up blocking future message delivery.
 */
public interface TopicListener<T extends Serializable> {

    /**
     * Callback method that is called when a message is published to the topic that the listener has subscribed to.
     *
     * @param message the message
     */
    void onMessage(@Nonnull MessageEvent<T> message);
}
