package com.atlassian.bitbucket.topic;

import com.atlassian.bitbucket.cluster.ClusterNode;

import javax.annotation.Nonnull;
import java.util.Date;

/**
 * Represents a message being published to a {@link TopicService topic}
 */
public interface MessageEvent<T> {

    /**
     * @return the message that was published
     */
    @Nonnull
    T getMessage();

    /**
     * @return the time the message was published
     */
    @Nonnull
    Date getPublishTime();

    /**
     * @return the node the message was published on
     */
    @Nonnull
    ClusterNode getSource();

    /**
     * @return the topic the message was published to
     */
    @Nonnull
    String getTopic();
}
