package com.atlassian.bitbucket.scm.signed;

import com.atlassian.bitbucket.scm.ScmExtendedCommandFactory;
import com.atlassian.bitbucket.util.BuilderSupport;

import javax.annotation.Nonnull;
import java.util.Iterator;

import static java.util.Objects.requireNonNull;

/**
 * Request that describes what signed objects to
 * {@link ScmExtendedCommandFactory#signedObjects(SignedObjectsParameters, SignedObjectCallback) retrieve} from the SCM.
 *
 * @since 5.1
 */
public class SignedObjectsParameters {

    private final SignedObjectIdSource objectIdSource;

    private SignedObjectsParameters(Builder builder) {
        objectIdSource = requireNonNull(builder.objectIdSource, "objectIdSource");
    }

    /**
     * @return an {@link Iterator} over the object IDs to retrieve. Each of the items in the iterator may be a commit
     *         ID or a ref ID, in which case the object that is referenced will be returned.
     */
    @Nonnull
    public SignedObjectIdSource getObjectIdSource() {
        return objectIdSource;
    }

    public static class Builder extends BuilderSupport {

        private SignedObjectIdSource objectIdSource;

        public Builder() {
        }

        @Nonnull
        public SignedObjectsParameters build() {
            return new SignedObjectsParameters(this);
        }

        @Nonnull
        public Builder objectIdSource(@Nonnull SignedObjectIdSource value) {
            objectIdSource = requireNonNull(value, "objectIdSource");

            return this;
        }
    }
}
