package com.atlassian.bitbucket.scm;

import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;

/**
 * Parameters for requesting a {@link ScmCommandFactory#size file's size}.
 *
 * @see ScmCommandFactory#size(SizeCommandParameters)
 * @since 7.7
 */
public class SizeCommandParameters extends AbstractCommitCommandParameters {

    private SizeCommandParameters(Builder builder) {
        super(builder);

        if (StringUtils.isBlank(getCommitId())) {
            throw new IllegalStateException("A commit ID must provided when querying for a file's size");
        }
    }

    public static class Builder extends AbstractCommitParametersBuilder<Builder> {

        public Builder() {
        }

        @Nonnull
        public SizeCommandParameters build() {
            return new SizeCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
