package com.atlassian.bitbucket.scm;

import javax.annotation.Nonnull;
import java.io.IOException;

/**
 * Augments a {@link CommandErrorHandler}, {@link CommandInputHandler} or {@link CommandOutputHandler} with an enhanced
 * {@link #onComplete(CommandSummary) completion handler} that is provided with a {@link CommandSummary summary} of the
 * command that was executed.
 * <p>
 * Some handlers need better insight into how the command they were attached to completed, rather than simply knowing
 * when completion happens. For example, handlers which are attached to callbacks may need to know whether the command
 * succeeded or failed so they can notify the callback appropriately. The base {@code complete()} method inherited from
 * the handler interfaces does not offer that level of detail.
 */
public interface CommandSummaryHandler {

    /**
     * Notifies the handler that the {@link Command command} it was attached to has completed, and provides a summary
     * of the command.
     *
     * @param summary the command's summary
     * @throws IOException if processing the completion results in an exception
     */
    void onComplete(@Nonnull CommandSummary summary) throws IOException;
}
