package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.10
 */
public class SimpleDetailedRefChange extends SimpleRefChange implements DetailedRefChange {

    private final RefChangeDetails added;
    private final RefChangeDetails removed;

    private SimpleDetailedRefChange(Builder builder) {
        super(builder);
        added = requireNonNull(builder.added, "added");
        removed = requireNonNull(builder.removed, "removed");
    }

    @Nonnull
    @Override
    public RefChangeDetails getAdded() {
        return added;
    }

    @Nonnull
    @Override
    public RefChangeDetails getRemoved() {
        return removed;
    }

    public static class Builder extends AbstractBuilder<Builder> {

        private RefChangeDetails added;
        private RefChangeDetails removed;

        public Builder(@Nonnull RefChange change) {
            super(change);
        }

        @Nonnull
        public SimpleDetailedRefChange build() {
            return new SimpleDetailedRefChange(this);
        }

        @Nonnull
        public Builder added(@Nonnull RefChangeDetails value) {
            this.added = requireNonNull(value, "added");
            return self();
        }

        @Nonnull
        public Builder removed(@Nonnull RefChangeDetails value) {
            this.removed = requireNonNull(value, "removed");
            return self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}