package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Indicates the operation could not be completed because a existing ref already exists
 * with a name that conflicts with the one being created.
 */
public class ConflictingRefNameException extends InvalidRefNameException {

    public ConflictingRefNameException(@Nonnull KeyedMessage message, @Nonnull MinimalRef ref) {
        super(message, ref.getDisplayId());
    }
}
