package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Request object used for {@link PullRequestService#decline(PullRequestDeclineRequest) declining a pull request}.
 */
public class PullRequestDeclineRequest extends AbstractPullRequestRequest {

    private final String comment;
    private final int version;

    private PullRequestDeclineRequest(Builder builder) {
        super(builder);

        comment = builder.comment;
        version = builder.version;
    }

    /**
     * @return the comment associated with the decline or null if no comment is to be added
     */
    @Nullable
    public String getComment() {
        return comment;
    }

    /**
     * @return the expected version of the pull request
     */
    public int getVersion() {
        return version;
    }

    public static class Builder extends AbstractBuilder<Builder> {

        private final int version;

        private String comment;

        public Builder(@Nonnull PullRequest pullRequest, int version) {
            super(pullRequest);

            this.version = version;
        }

        public Builder(int repositoryId, long pullRequestId, int version) {
            super(repositoryId, pullRequestId);

            this.version = version;
        }

        @Nonnull
        public PullRequestDeclineRequest build() {
            return new PullRequestDeclineRequest(this);
        }

        @Nonnull
        public Builder comment(@Nullable String value) {
            comment = value;

            return self();
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
