package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Indicates a pull request could not be created because it would have no commits. Each pull request is required to
 * pull in at least one new commit.
 */
public class EmptyPullRequestException extends IntegrityException {

    private static final long serialVersionUID = 1;

    private final PullRequestRef fromRef;
    private final PullRequestRef toRef;

    /**
     * @param message a message explaining why the pull request could not be created
     * @param fromRef the requested "from" ref for the pull request
     * @param toRef   the requested "to" ref for the pull request
     */
    public EmptyPullRequestException(@Nonnull KeyedMessage message, @Nonnull PullRequestRef fromRef,
                                     @Nonnull PullRequestRef toRef) {
        super(message);

        this.fromRef = requireNonNull(fromRef, "fromRef");
        this.toRef = requireNonNull(toRef, "toRef");
    }

    @Nonnull
    public PullRequestRef getFromRef() {
        return fromRef;
    }

    @Nonnull
    public PullRequestRef getToRef() {
        return toRef;
    }

}
