package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown to indicate a Mesh node rejected a public key. This can be raised for a variety of reasons, including (but
 * not limited to):
 * <ul>
 *     <li>the key used an unsupported or unknown algorithm</li>
 *     <li>the key was corrupted in transmission</li>
 *     <li>a key was specified, but the node has no record of the key</li>
 *     <li>etc.</li>
 * </ul>
 *
 * @since 8.0
 */
public class InvalidMeshNodeKeyException extends IllegalEntityStateException {

    public InvalidMeshNodeKeyException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public InvalidMeshNodeKeyException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
