package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Thrown to indicate the {@link HookScriptService#getById requested hook script} does not exist.
 *
 * @since 6.2
 */
public class NoSuchHookScriptException extends NoSuchEntityException {

    private final long id;

    public NoSuchHookScriptException(@Nonnull KeyedMessage message, long id) {
        super(message);

        this.id = id;
    }

    /**
     * @return the ID of the hook script that was requested
     */
    public long getId() {
        return id;
    }
}
