package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Thrown when {@link HookScriptService#update updating} a {@link HookScript hook script} fails due to concurrent
 * updates, or a {@link HookScript#getVersion version} mismatch.
 *
 * @since 6.2
 */
public class HookScriptOutOfDateException extends EntityOutOfDateException {

    public HookScriptOutOfDateException(KeyedMessage message, Throwable cause) {
        super(message, cause);
    }

    public HookScriptOutOfDateException(KeyedMessage message, int expectedVersion, int currentVersion) {
        super(message, expectedVersion, currentVersion);
    }
}
