package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.repository.RepositoryRef;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * Request that is provided to {@code repository-hook} plugin modules when two branches are merged in a repository.
 *
 * @see StandardRepositoryHookTrigger#MERGE
 * @since 5.0
 */
public interface MergeHookRequest extends RepositoryHookRequest {

    /**
     * @return the branch or tag being merged into the {@link #getToRef() target branch}
     */
    @Nonnull
    RepositoryRef getFromRef();

    /**
     * @return the merge commit hash. Can be {@link Optional#empty()} if this is a {@link #isDryRun() dry-run} request.
     */
    @Nonnull
    Optional<String> getMergeHash();

    /**
     * @return the commit message. Can be {@link Optional#empty()} if this is a {@link #isDryRun() dry-run} request.
     */
    @Nonnull
    Optional<String> getMessage();

    /**
     * @return the merge strategy ID
     * @since 5.5
     */
    @Nonnull
    Optional<String> getStrategyId();

    /**
     * @return the target branch
     */
    @Nonnull
    RepositoryRef getToRef();

    /**
     * @return {@code true} if the {@link #getFromRef() from-ref} and the {@link #getToRef() to-ref} are in different
     *         repositories, otherwise {@code false}
     */
    boolean isCrossRepository();
}
