package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.2
 */
public abstract class AbstractUpdateRepositoryHookRequest {

    private final String hookKey;
    private final Scope scope;

    protected AbstractUpdateRepositoryHookRequest(AbstractBuilder builder) {
        hookKey = builder.hookKey;
        scope = builder.scope;
    }

    @Nonnull
    public String getHookKey() {
        return hookKey;
    }

    @Nonnull
    public Scope getScope() {
        return scope;
    }

    public abstract static class AbstractBuilder {

        private final Scope scope;
        private final String hookKey;

        public AbstractBuilder(@Nonnull Scope scope, @Nonnull String hookKey) {
            this.hookKey = requireNonNull(hookKey, "hookKey");
            this.scope = requireNonNull(scope, "scope");
        }
    }
}
