package com.atlassian.bitbucket.event.project;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a project is created.
 * <p>
 * This event is internally audited at the {@link CoverageLevel#BASE} level.
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.project.created")
public class ProjectCreatedEvent extends ProjectEvent {

    public ProjectCreatedEvent(@Nonnull Object source, @Nonnull Project project) {
        super(source, project);
    }
}
