package com.atlassian.bitbucket.event.license;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when the license is changed.
 * <p>
 * This event is internally audited.
 */
@AsynchronousPreferred
@TransactionAware
public class LicenseChangedEvent extends ApplicationEvent {

    private final BitbucketServerLicense newLicense;
    private final BitbucketServerLicense previousLicense;

    public LicenseChangedEvent(@Nonnull Object source) {
        this(source, null, null);
    }

    /**
     * Allows passing in the old and new licenses optionally
     * @param source the publisher of this event
     * @param newLicense new license that has been updated. Can be null
     * @param previousLicense license that existed before updating this license. Can be null
     *
     * @since 7.0
     */
    public LicenseChangedEvent(@Nonnull Object source,
                               @Nullable BitbucketServerLicense newLicense,
                               @Nullable BitbucketServerLicense previousLicense) {
        super(requireNonNull(source, "source"));
        this.newLicense = newLicense;
        this.previousLicense = previousLicense;
    }

    @Nullable
    public BitbucketServerLicense getNewLicense() {
        return newLicense;
    }

    @Nullable
    public BitbucketServerLicense getPreviousLicense() {
        return previousLicense;
    }
}
