package com.atlassian.bitbucket.comment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A request for making changes to a {@link Comment comment}
 *
 * @since 5.0
 */
public class CommentUpdateRequest {

    private final long commentId;
    private final CommentSeverity severity;
    private final CommentState state;
    private final String text;
    private final int version;

    private CommentUpdateRequest(@Nonnull Builder builder) {
        commentId = builder.commentId;
        severity = builder.severity;
        state = builder.state;
        text = builder.text;
        version = builder.version;
    }

    public long getCommentId() {
        return commentId;
    }

    /**
     * @since 6.7
     */
    @Nullable
    public CommentSeverity getSeverity() {
        return severity;
    }

    /**
     * @since 6.7
     */
    @Nullable
    public CommentState getState() {
        return state;
    }

    @Nullable
    public String getText() {
        return text;
    }

    public int getVersion() {
        return version;
    }

    public static class Builder {

        private final long commentId;

        private CommentSeverity severity;
        private CommentState state;
        private String text;
        private int version;

        public Builder(long commentId) {
            this.commentId = commentId;
        }

        @Nonnull
        public CommentUpdateRequest build() {
            return new CommentUpdateRequest(this);
        }

        /**
         * @since 6.7
         */
        @Nonnull
        public Builder severity(@Nullable CommentSeverity value) {
            severity = value;
            return this;
        }

        /**
         * @since 6.7
         */
        @Nonnull
        public Builder state(@Nullable CommentState value) {
            state = value;
            return this;
        }

        @Nonnull
        public Builder text(@Nullable String value) {
            text = value;
            return this;
        }

        @Nonnull
        public Builder version(int value) {
            version = value;
            return this;
        }
    }
}
