package com.atlassian.bitbucket.build.status;

import javax.annotation.Nonnull;
import java.net.URI;
import java.util.Optional;

/**
 * A collection of hyperlinks to be displayed on a build status, that redirect the user to information about a
 * given build.
 *
 * @since 7.8
 */
public interface BuildStatusLinks {

    /**
     * @return a URL pointing to the artifacts created for this build if it exists; empty otherwise
     */
    @Nonnull
    Optional<URI> getArtifactsLink();

    /**
     * @return a URL pointing to the logs for this build if it exists; empty otherwise
     */
    Optional<URI> getLogsLink();
}
