package com.atlassian.bitbucket.build;

import javax.annotation.Nullable;
import java.util.Arrays;
import java.util.Optional;

import static java.util.Optional.empty;

/**
 * @since 6.7
 */
public enum BuildOrder {

    NEWEST,
    OLDEST,
    STATE;

    public static Optional<BuildOrder> fromString(@Nullable String value) {
        if (value == null) {
            return empty();
        }
        return Arrays.stream(values())
                .filter(v -> v.name().equalsIgnoreCase(value))
                .findAny();
    }
}
