package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A specialization of {@link AuthenticationException} that is thrown during authentication when a
 * key does not meet the requirements of the system.
 *
 * @since 8.7
 */
public class SshAuthenticationInsecureKeyException extends AuthenticationException {

    public SshAuthenticationInsecureKeyException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public SshAuthenticationInsecureKeyException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}