package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * A specialisation of {@link AuthenticationException}, thrown to indicate the user cannot be authenticated because
 * their account is no longer active.
 */
public class InactiveUserAuthenticationException extends AuthenticationException {

    public InactiveUserAuthenticationException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
