package com.atlassian.bitbucket;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Base class for exceptions thrown when attempts are made to use features which have been disabled.
 * <p>
 * Some features, like forking or uploading attachments, can be globally (or specifically) disabled by administrators.
 * User interface cues for disabled features are hidden, but API methods and REST endpoints cannot be. When an attempt
 * is made to access a disabled feature, subclasses of this exception will be thrown.
 */
public class FeatureDisabledException extends ServiceException {

    public FeatureDisabledException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
