/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.AbstractRepositoryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RepositoryForkRequest
extends AbstractRepositoryRequest {
    private final String defaultBranch;
    private final Repository parent;
    private final Project project;

    private RepositoryForkRequest(Builder builder) {
        super(builder);
        this.defaultBranch = builder.defaultBranch;
        this.project = builder.project;
        this.parent = builder.parent;
    }

    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Nonnull
    public Repository getParent() {
        return this.parent;
    }

    @Nullable
    public Project getProject() {
        return this.project;
    }

    public static class Builder
    extends AbstractRepositoryRequest.AbstractBuilder<Builder> {
        private String defaultBranch;
        private Repository parent;
        private Project project;

        public Builder() {
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
            this.parent = repository;
            this.publiclyAccessible = false;
        }

        public Builder(@Nonnull RepositoryForkRequest request) {
            super(request);
            this.parent = request.getParent();
            this.project = request.getProject();
        }

        @Nonnull
        public RepositoryForkRequest build() {
            Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"parent");
            this.name = (String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)this.parent.getName());
            return new RepositoryForkRequest(this);
        }

        @Nonnull
        public Builder defaultBranch(@Nullable String value) {
            this.defaultBranch = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Override
        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = value;
            return this.self();
        }

        @Nonnull
        public Builder parent(@Nonnull Repository value) {
            this.parent = Objects.requireNonNull(value, "parent");
            return this.self();
        }

        @Nonnull
        public Builder project(@Nullable Project value) {
            this.project = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

