/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractProjectRequest {
    private final String description;
    private final String key;
    private final String name;
    private final String namespace;
    private final boolean publiclyAccessible;

    AbstractProjectRequest(AbstractBuilder builder) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)builder.key), (Object)"The key of the the project is required");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)builder.name), (Object)"The name of the project is required");
        this.description = builder.description;
        this.name = builder.name;
        this.namespace = builder.namespace;
        this.key = builder.key;
        this.publiclyAccessible = builder.publiclyAccessible;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Deprecated
    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public boolean isPublic() {
        return this.publiclyAccessible;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder>
    extends BuilderSupport {
        private String description;
        private String key;
        private String name;
        private boolean publiclyAccessible;
        private String namespace;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(@Nonnull Project project) {
            this.description = Objects.requireNonNull(project, "project").getDescription();
            this.key = project.getKey();
            this.name = project.getName();
            this.namespace = project.getNamespace();
            this.publiclyAccessible = project.isPublic();
        }

        @Nonnull
        public B description(@Nullable String value) {
            this.description = value;
            return this.self();
        }

        @Nonnull
        public B key(@Nonnull String value) {
            this.key = Objects.requireNonNull(value, "key");
            return this.self();
        }

        @Nonnull
        public B name(@Nonnull String value) {
            this.name = Objects.requireNonNull(value, "name");
            return this.self();
        }

        @Deprecated
        @Nonnull
        public B namespace(@Nullable String value) {
            this.namespace = value;
            return this.self();
        }

        @Nonnull
        public B publiclyAccessible(boolean value) {
            this.publiclyAccessible = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

