/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCreateRefRequest {
    private final String message;
    private final String name;
    private final Repository repository;
    private final String startPoint;

    protected AbstractCreateRefRequest(AbstractBuilder builder) {
        this.message = builder.message;
        this.name = builder.name;
        this.repository = builder.repository;
        this.startPoint = builder.startPoint;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getStartPoint() {
        return this.startPoint;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder, R extends AbstractCreateRefRequest>
    extends BuilderSupport {
        private final String name;
        private final Repository repository;
        private final String startPoint;
        private String message;

        protected AbstractBuilder(@Nonnull Repository repository, @Nonnull String name, @Nonnull String startPoint) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            this.name = AbstractBuilder.checkNotBlank(name, "name");
            this.startPoint = AbstractBuilder.checkNotBlank(startPoint, "startPoint");
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B message(@Nullable String value) {
            this.message = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public abstract B self();
    }
}

