/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.server;

import com.atlassian.bitbucket.server.Feature;
import javax.annotation.Nonnull;

public enum StandardFeature implements Feature
{
    ATTACHMENTS("attachments"),
    AUTH_CAPTCHA("auth.captcha"),
    COMMIT_GRAPH("commit.graph"),
    DIAGNOSTICS("diagnostics"),
    FILE_EDITOR("file.editor"),
    FORKS("forks"),
    GETTING_STARTED("getting.started.page"),
    DATA_CENTER_MIGRATION_EXPORT("data.center.migration.export"),
    DATA_CENTER_MIGRATION_IMPORT("data.center.migration.import", true),
    PERSONAL_REPOS("personal.repos"),
    PUBLIC_ACCESS("public.access"),
    PULL_REQUEST_DELETION("pull.request.deletion"),
    RATE_LIMITING("rate.limiting", true),
    SMART_MIRRORS("smart.mirrors", true),
    TIME_ZONE_ONBOARDING("user.time.zone.onboarding");

    private final boolean dataCenter;
    private final String key;

    private StandardFeature(String key) {
        this(key, false);
    }

    private StandardFeature(String key, boolean dataCenter) {
        this.dataCenter = dataCenter;
        this.key = key;
    }

    @Nonnull
    public static StandardFeature fromKey(String value) {
        for (StandardFeature feature : StandardFeature.values()) {
            if (!feature.getKey().equals(value)) continue;
            return feature;
        }
        throw new IllegalArgumentException("No Feature is associated with key [" + value + "]");
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean isDataCenter() {
        return this.dataCenter;
    }
}

