/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.mirror;

import com.atlassian.bitbucket.event.mirror.AbstractRepositoryMirrorEvent;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RepositoryMirrorSynchronizedEvent
extends AbstractRepositoryMirrorEvent {
    private final Collection<MinimalRef> failedRefs;
    private final Collection<RefChange> refChanges;

    private RepositoryMirrorSynchronizedEvent(Builder builder) {
        super(builder);
        this.failedRefs = builder.failedRefs;
        this.refChanges = builder.refChanges;
    }

    @Deprecated
    public RepositoryMirrorSynchronizedEvent(@Nonnull Object source, @Nonnull String mirrorServerId, @Nonnull Repository repository, @Nonnull Collection<MinimalRef> failedRefs, @Nonnull Collection<RefChange> refChanges) {
        super(source, mirrorServerId, repository);
        this.failedRefs = ImmutableList.copyOf(Objects.requireNonNull(failedRefs, "failedRefs"));
        this.refChanges = ImmutableList.copyOf(Objects.requireNonNull(refChanges, "refChanges"));
    }

    @Nonnull
    public Collection<MinimalRef> getFailedRefs() {
        return this.failedRefs;
    }

    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    public static class Builder
    extends AbstractRepositoryMirrorEvent.Builder<Builder, RepositoryMirrorSynchronizedEvent> {
        private Collection<MinimalRef> failedRefs;
        private Collection<RefChange> refChanges;

        @Override
        @Nonnull
        public RepositoryMirrorSynchronizedEvent build() {
            this.validate();
            return new RepositoryMirrorSynchronizedEvent(this);
        }

        @Nonnull
        public Builder failedRefs(Collection<MinimalRef> value) {
            this.failedRefs = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder refChanges(Collection<RefChange> value) {
            this.refChanges = Objects.requireNonNull(value, "refChanges");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.failedRefs == null) {
                throw new IllegalStateException("failedRefs is required");
            }
            if (this.refChanges == null) {
                throw new IllegalStateException("refChanges is required");
            }
        }
    }
}

