package com.atlassian.bitbucket.watcher;

import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

public interface WatchableVisitor<T> {

    T visit(@Nonnull CommitDiscussion discussion);

    T visit(@Nonnull PullRequest pullRequest);

    /**
     * @since 5.10
     */
    T visit(@Nonnull Repository repository);
}
