package com.atlassian.bitbucket.validation.annotation;

import com.atlassian.bitbucket.validation.ConditionalNotEmptyValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

@Constraint(validatedBy = {ConditionalNotEmptyValidator.class})
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface ConditionalNotEmpty {

    String message() default "";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    /** @return fields to test for non-emptiness */
    String[] fields() default {};

    /** @return field on which the violation will be reported */
    String targetField() default "";

    /**
     * Support for multiple {@link ConditionalNotEmpty} annotations on the same type
     */
    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
        ConditionalNotEmpty[] value();
    }

}
