package com.atlassian.bitbucket.validation;

import com.atlassian.bitbucket.validation.annotation.HttpURL;

import java.net.MalformedURLException;
import java.net.URI;

/**
 * Validate that the string is a valid http or https URL.
 */
public class HttpURLValidator extends BaseUrlValidator<HttpURL> {

    public HttpURLValidator() {
        super(true, "http", "https");
    }

    @Override
    public void initialize(HttpURL constraintAnnotation) {
    }

    @Override
    protected boolean isValid(URI uri) {
        // Check that it is also a valid URL. This validates that the port is numeric
        try {
            uri.toURL();
        } catch (MalformedURLException e) {
            return false;
        } catch (IllegalArgumentException e) {
            // If URL is not absolute
            return false;
        }

        return super.isValid(uri);
    }
}
