package com.atlassian.bitbucket.util;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import java.io.Serializable;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * A default immutable implementation of the {@link Progress} interface.
 */
public class ProgressImpl implements Progress, Serializable {

    private final String message;
    private final int percentage;

    public ProgressImpl(@Nonnull String message, @Nonnegative int percentage) {
        checkNotNull(message, "message cannot be null");
        checkArgument(percentage >= 0, "percentage cannot be negative");
        checkArgument(percentage <= 100, "percentage cannot greater than 100");
        this.message = message;
        this.percentage = percentage;
    }

    public ProgressImpl(@Nonnull Progress progress) {
        this(checkNotNull(progress, "progress").getMessage(), progress.getPercentage());
    }

    @Nonnull
    @Override
    public String getMessage() {
        return message;
    }

    @Nonnegative
    @Override
    public int getPercentage() {
        return percentage;
    }
}
