package com.atlassian.bitbucket.util;

import javax.annotation.Nonnull;

/**
 * Pagination for a request.
 */
public interface PageRequest {

    /**
     * The maximum size of any page limit.
     */
    int MAX_PAGE_LIMIT = 1048576;

    /**
     * @param maxLimit the maximum limit allowed in a page
     * @return a copy of this pageRequest with the minimum of limit and maxLimit
     */
    @Nonnull
    PageRequest buildRestrictedPageRequest(int maxLimit);

    /**
     * @return the maximum allowed size of the page
     */
    int getLimit();

    /**
     * @return the index of the  element in the result set that this page will start at
     */
    int getStart();
}
