package com.atlassian.bitbucket.throttle;

import com.atlassian.bitbucket.event.throttle.TicketAcquiredEvent;

import javax.annotation.Nonnull;

/**
 * Provides information about a {@link Ticket ticket}.
 * <p>
 * Note: The actual {@link Ticket} is <i>not available from this context</i>. Event handlers which receive this
 * context on a {@link TicketAcquiredEvent TicketAcquiredEvent} should not be able to
 * {@link Ticket#close release} tickets.
 */
public interface TicketContext {

    /**
     * Registers a task that is executed when the ticket is released. If the ticket has already been released when
     * the callback is added, the callback will be run immediately.
     *
     * @param callback a task to execute when the ticket is released
     */
    void addReleaseCallback(@Nonnull Runnable callback);

    /**
     * Retrieves the name of the resource associated with the ticket.
     *
     * @return the resource name
     */
    @Nonnull
    String getResourceName();
}
