package com.atlassian.bitbucket.throttle;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Thrown to indicate a resource is busy.
 *
 * @see ThrottleService#acquireTicket(String)
 */
public class ResourceBusyException extends ServiceException {

    private final String resourceName;
    
    public ResourceBusyException(KeyedMessage message, @Nonnull String resourceName) {
        super(message);

        this.resourceName = requireNonNull(resourceName, "resourceName");
    }

    /**
     * @return the busy resource's name
     */
    @Nonnull
    public String getResourceName() {
        return resourceName;
    }
}
