package com.atlassian.bitbucket.task;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Allows the update of a {@link Task task}.
 *
 * @see TaskService#update(TaskUpdateRequest)
 */
public class TaskUpdateRequest {

    private final TaskState state;
    private final Task task;
    private final String text;

    private TaskUpdateRequest(Builder builder) {
        this.state = builder.state;
        this.task = checkNotNull(builder.task, "task");
        this.text = builder.text;
    }

    @Nullable
    public TaskState getState() {
        return state;
    }

    @Nonnull
    public Task getTask() {
        return task;
    }

    @Nullable
    public String getText() {
        return text;
    }

    public static class Builder {

        private final Task task;
        private TaskState state;
        private String text;

        public Builder(@Nonnull Task task) {
            this.task = checkNotNull(task, "task");
        }

        public TaskUpdateRequest build() {
            return new TaskUpdateRequest(this);
        }

        public Builder state(@Nonnull TaskState value) {
            this.state = checkNotNull(value, "state");
            return this;
        }

        public Builder text(@Nonnull String value) {
            this.text = checkNotNull(value, "text");
            return this;
        }
    }
}
