package com.atlassian.bitbucket.task;

/**
 * Enumerates the possible {@link Task#getState() states} a task can be in.
 *
 * @see Task#getState()
 */
public enum TaskState {

    /**
     * The {@link Task task} is open.
     */
    OPEN(0),
    /**
    * The {@link Task task} has been resolved.
    */
    RESOLVED(1);

    private final int id;

    private TaskState(int id) {
        this.id = id;
    }

    public static TaskState fromId(int id) {
        for (TaskState value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No TaskState is associated with ID [" + id + "]");
    }

    public int getId() {
        return id;
    }
}
