package com.atlassian.bitbucket.task;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Service to manage {@link Task}s.
 */
public interface TaskService {

    /**
     * Create a task.
     *
     * @param request request detailing the task's properties
     * @return an instance of the created task
     */
    @Nonnull
    Task create(@Nonnull TaskCreateRequest request);

    /**
     * Delete a task.
     *
     * @param taskId the id of the task to delete
     */
    void delete(long taskId);

    /**
     * Get a task by its ID.
     *
     * @param taskId the ID of the task to retrieve
     * @return the task matching the ID or {@code null} if none matches or the task is not visible to the current user
     */
    @Nullable
    Task getById(long taskId);

    /**
     * Update a task.
     *
     * @param request the properties to update
     * @return an instance of the updated task
     */
    @Nonnull
    Task update(@Nonnull TaskUpdateRequest request);

}
