package com.atlassian.bitbucket.task;

import javax.annotation.Nonnull;

/**
 * The anchor of a task, such as a pull request's comment.
 *
 * @see Task#getAnchor()
 */
public interface TaskAnchor {

    /**
     * @return the anchor's ID
     */
    long getId();

    /**
     * Accepts the provided {@link TaskAnchorVisitor visitor} and invokes the appropriate {@code visit()} overload
     * for this type of task anchor, returning its result.
     * <p>
     * Note: Nullability for the return value is intentionally not documented one way or another. It is expected that
     * the <i>caller</i> will know the nullability of the visitor implementation they are passing and code accordingly.
     *
     * @param visitor the visitor to invoke
     * @return the result of the invoked {@code visit} method
     */
    <T> T accept(@Nonnull TaskAnchorVisitor<T> visitor);
}
