package com.atlassian.bitbucket.server;

import javax.annotation.Nonnull;

/**
 * Provides access to {@code bitbucket.properties} flags for enabling/disabling various {@link Feature features}.
 *
 * @since 4.1
 */
public interface FeatureManager {

    /**
     * @param feature the feature to check
     * @return {@code true} if the feature is available for the current license type; otherwise {@code false}
     */
    boolean isAvailable(@Nonnull Feature feature);

    /**
     * @param feature the feature to check
     * @return {@code true} if the feature is available and enabled; otherwise, {@code false}
     */
    boolean isEnabled(@Nonnull Feature feature);

    /**
     * @param feature the feature to check
     * @param defaultValue the value to return if no property has been defined for the feature
     * @return {@code true} if the feature is available and enabled, {@code false} if the feature is not available or
     *         disabled; otherwise {@code defaultValue}
     */
    boolean isEnabled(@Nonnull Feature feature, boolean defaultValue);
}
