package com.atlassian.bitbucket.scope;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * Describes a scope within the system
 *
 * @since 5.0
 */
public interface Scope {

    <T> T accept(@Nonnull ScopeVisitor<T> visitor);

    /**
     * @return the resource ID of this {@link Scope}
     */
    @Nonnull
    Optional<Integer> getResourceId();

    /**
     * @return the type of this {@link Scope}
     */
    @Nonnull
    ScopeType getType();
}