package com.atlassian.bitbucket.scope;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * Describes the system wide scope
 *
 * @since 5.0
 */
public class GlobalScope implements Scope {

    public <T> T accept(@Nonnull ScopeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Nonnull
    @Override
    public Optional<Integer> getResourceId() {
        return Optional.empty();
    }

    @Nonnull
    public ScopeType getType() {
        return ScopeType.GLOBAL;
    }

    @Override
    public String toString() {
        return "GlobalScope";
    }
}
