package com.atlassian.bitbucket.scm.ref;

import javax.annotation.Nonnull;

public class CreateBranchCommandParameters extends AbstractCreateRefCommandParameters {

    protected CreateBranchCommandParameters(AbstractCreateBranchBuilder builder) {
        super(builder);
    }

    public static class Builder extends AbstractCreateBranchBuilder<Builder> {

        @Nonnull
        public CreateBranchCommandParameters build() {
            validate();

            return new CreateBranchCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }

    public abstract static class AbstractCreateBranchBuilder<B extends AbstractCreateBranchBuilder<B>>
            extends AbstractCreateRefBuilder<B> {
    }
}
