package com.atlassian.bitbucket.scm.bulk;

import com.atlassian.bitbucket.commit.graph.CommitGraphNode;

/**
 * The status of the traversal after visiting a node in the commit graph.
 *
 * @see BulkTraversalCallback#onNode(CommitGraphNode)
 * @since 5.11
 */
public enum BulkTraversalStatus {
    /**
     * Continue traversing the commit graph
     */
    CONTINUE,
    /**
     * Finish traversing the commit graph
     */
    FINISH
}
